
################################################################################
##                                                                            ##
##  This file is part of NCrystal (see https://mctools.github.io/ncrystal/)   ##
##                                                                            ##
##  Copyright 2015-2026 NCrystal developers                                   ##
##                                                                            ##
##  Licensed under the Apache License, Version 2.0 (the "License");           ##
##  you may not use this file except in compliance with the License.          ##
##  You may obtain a copy of the License at                                   ##
##                                                                            ##
##      http://www.apache.org/licenses/LICENSE-2.0                            ##
##                                                                            ##
##  Unless required by applicable law or agreed to in writing, software       ##
##  distributed under the License is distributed on an "AS IS" BASIS,         ##
##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  ##
##  See the License for the specific language governing permissions and       ##
##  limitations under the License.                                            ##
##                                                                            ##
################################################################################

################################################################################
#                                                                              #
# Exports NCrystal targets, and provides a few paths and values of build       #
# options.                                                                     #
#                                                                              #
#                                                                              #
################################################################################

#First make sure our file work when CMake is new enough, but the user have a
#very old version in their cmake_minimum_required statements (cf. github
#discussion/issue #137):
cmake_policy(PUSH)#NB: We POP at the end of this file.
cmake_policy(VERSION 3.16...3.30)

#Export a few directory paths (relocatable):
set( NCrystal_CMAKEDIR "${CMAKE_CURRENT_LIST_DIR}" )
get_filename_component( NCrystal_PREFIX "${NCrystal_CMAKEDIR}/../../../../" ABSOLUTE )
get_filename_component( NCrystal_DATAROOT "${NCrystal_PREFIX}/share/NCrystal" ABSOLUTE )

get_filename_component( NCrystal_BINDIR "${NCrystal_CMAKEDIR}/../" ABSOLUTE )
get_filename_component( NCrystal_LIBDIR "${NCrystal_CMAKEDIR}/../../" ABSOLUTE )
get_filename_component( NCrystal_INCDIR "${NCrystal_CMAKEDIR}/../" ABSOLUTE )
if ( "xEMBED" STREQUAL "xON" )
  get_filename_component( NCrystal_DATAFILESDIR "${NCrystal_CMAKEDIR}/../../../" ABSOLUTE )
  set( NCrystal_OPTION_INSTALL_DATA        "ON" )
else()
  set( NCrystal_DATAFILESDIR "")
  set( NCrystal_OPTION_INSTALL_DATA        "OFF" )
endif()

if ( "xEMBED" STREQUAL "xEMBED" )
  set( NCrystal_OPTION_EMBED_DATA          "ON" )
else()
  set( NCrystal_OPTION_EMBED_DATA          "OFF" )
endif()

#Config variables (backwards compatible names):
set( NCrystal_OPTION_BUILD_EXAMPLES      "OFF" )
set( NCrystal_OPTION_BUILD_G4HOOKS       "OFF" )
set( NCrystal_OPTION_INSTALL_PY          "OFF" )
set( NCrystal_OPTION_MODIFY_RPATH        "ON" )
set( NCrystal_OPTION_NO_DIRECT_PYMODINST "OFF" )
set( NCrystal_OPTION_NAMESPACE "" )

#Config variables (autogenerated list):
set( _tmpnc_opts "NCRYSTAL_ENABLE_EXAMPLES;NCRYSTAL_ENABLE_DATA;NCRYSTAL_MODIFY_RPATH;NCRYSTAL_ENABLE_DYNLOAD;NCRYSTAL_BUILD_STRICT;NCRYSTAL_ENABLE_CPACK;NCRYSTAL_QUIET;NCRYSTAL_SKIP_INSTALL;NCRYSTAL_ENABLE_THREADS;NCRYSTAL_ENABLE_TESTING;NCRYSTAL_ENABLE_CFGAPP;NCRYSTAL_WINEXPORTALL;NCRYSTAL_ENABLE_TESTING;NCRYSTAL_ENABLE_CORE_TESTING;NCRYSTAL_NAMESPACE" )
set( _tmpnc_optsvals "OFF;EMBED;ON;ON;OFF;ON;OFF;OFF;ON;OFF;ON;ON;OFF;OFF;" )
while( _tmpnc_opts )
  list( POP_FRONT _tmpnc_opts _tmpnc_o )
  list( POP_FRONT _tmpnc_optsvals _tmpnc_v )
  string( REPLACE "NCRYSTAL_" "NCrystal_OPT_" _tmpnc_o "${_tmpnc_o}" )
  set( "${_tmpnc_o}" "${_tmpnc_v}" )
endwhile()
unset( _tmpnc_opts )
unset( _tmpnc_optsvals )
unset( _tmpnc_o )
unset( _tmpnc_v )

#Libname + old school NCrystal_LIBRARIES variable:
set( NCrystal_LIBNAME "libNCrystal.so" )#NB: generator expression
set( NCrystal_LIBRARIES "${NCrystal_LIBDIR}/${NCrystal_LIBNAME}" )

#Windows/scikitbuild mode needs fixup at the end of
#NCrystalTargets-<lowercaseconfig>.cmake:
if ( "OFF" )
  function( _ncrystal_fixup_ncrystaltargets )
    execute_process(
      COMMAND ncrystal-config --show libpath
      OUTPUT_VARIABLE "_tmp_ncrystal_libpath" OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    #Relying a bit too much on internal CMake implementation details for
    #comfort, but so far this is the only solution found:
    set(
      "_cmake_import_check_files_for_NCrystal::NCrystal"
      "${_tmp_ncrystal_libpath}"
      PARENT_SCOPE
    )
    get_filename_component( "tmp" "${CMAKE_CURRENT_LIST_FILE}" "NAME_WE")
    string( REPLACE "-" ";" "tmp" "${tmp}" )
    list(GET tmp -1 "tmp" )
    string( TOUPPER "${tmp}" "tmp" )

    set_target_properties(
      "NCrystal::NCrystal" PROPERTIES
      "IMPORTED_LOCATION_${tmp}"
      "${_tmp_ncrystal_libpath}"
    )
  endfunction()
endif()

#The NCrystal targets (not including the G4NCrystal targets!):
if(NOT TARGET NCrystal::NCrystal)
  include( "${NCrystal_CMAKEDIR}/NCrystalTargets.cmake" )
endif()

#Handle requested components. We do not have any, but for forward compatibility
#silently ignore any requested component name we do not recognise (unless it is
#REQUIRED):
foreach(tmp ${NCrystal_FIND_COMPONENTS})
  if ( NCrystal_FIND_REQUIRED_${tmp}  )
    set( NCrystal_FOUND "FALSE" )
  endif()
endforeach()

#Undo the policy changes we did above:
cmake_policy(POP)
