% mcPLOT-html(1)
% MCSTAS neutron Ray Tracing Team
% Jan. 07, 2026

# NAME

**mcplot-html** - Plotting the results of a McStas simulation in a browser

# SYNOPSIS

**mcplot-html** [-h] [-n] [-l] [--autosize] [--libpath [LIBPATH ...]] [-o OUTPUT] [simulation ...]

# DESCRIPTION

The front-end **mcplot-html** is a program that produces plots of all the
monitors in a simulation, and it is thus useful to get a quick overview of the
simulation results. In the simplest case, the front-end is run simply by typing
`mcplot-html`. This will plot any simulation data stored in the current
directory, which is where simulations store their results by default. If the
`--dir` or `--file` options have been used, the name of the file or directory
should be passed to *mcplot-html*, e.g. `mcplot-html dir` or
`mcplot-html file`. It is also possible to plot one single text (not
binary) data file from a given monitor, passing its name to `mcplot-html`.
The `-h` option will list valid options.

This is the web/html plotting tool (in browser).

# OPTIONS

**-h, --help**
:   show this help message and exit

**-n, --nobrowse**
:   do not open a webbrowser viewer

**-l, --log**
:   enable logscale on plot

**--autosize**
:   expand to window size on load

**--libpath [LIBPATH ...]**
:   js lib files path

**-o OUTPUT, --output OUTPUT**
:   specify output file (.html extension)

# FILES

/usr/share/mcstas/resources
/usr/share/mcstas/tools/Python/mccodelib/mccode_config.json
~/.mcstas/mccode_config.json
http://www.mcstas.org

# EXAMPLES

Run and plot the *Test_SX* example (Single crystal diffraction)
:   - `mcrun Test_SX.instr -d output_dir -n 1e7 TTH=13.4`
:   - `mcplot-html output_dir`

# AUTHORS

McStas Team (mcstas.org)

# SEE ALSO

mcstas(1), mcdoc(1), mcplot(1), mcrun(1), mcgui(1), mcdisplay(1)
